﻿'use strict';

// globals

var GInternetProtSettingsTabs = null;
var GCurrentInternetProtocolSetRegistryList = null;
var GLeftOrRight = "";
var Fmngtyp="";
var Fintname="";
var GProtocolNameForGetAccount="";
var FhasDefAcct=false;
var FhasCredentials=false;
var GAccMgrAccountSource=[];
var FAccountSourceOffset=0;
var FEnterCredsDirectlyIdx=-1;
var FAddAccountIdx=1;

function HandleCredentialsDeps()
{
   if (FhasCredentials && (FEnterCredsDirectlyIdx>=0))
   {
      var curidx=$("#comboAccount").jqxDropDownList("selectedIndex");

      const disable=(FEnterCredsDirectlyIdx!=curidx);
      const color=disable ? "gray" : "black";

      $("#inptUsername, #inptPassword").jqxInput({ disabled: disable });
      $("#lbUsername, #lbPassword").css("color", color);
   }
}

function BuildAccountSource()
{
   GAccMgrAccountSource=[txtPleaseSelect,txtAddAccount];

   FAddAccountIdx=1;

   if (FhasCredentials)
      FEnterCredsDirectlyIdx=GAccMgrAccountSource.push(txtEnterCredentials)-1;
   else
      FEnterCredsDirectlyIdx=-1;

   var pname;

   if (!Fmngtyp || Fmngtyp==undefined)
      GProtocolNameForGetAccount=Fintname;
   else
      GProtocolNameForGetAccount=Fmngtyp;

   $.ajax({
     url: "/getaccounts.php",
     type: "POST",
     async: false,
     data: { protocol: GProtocolNameForGetAccount, usedfor: Fintname, token: GClientToken },
     dataType: "json",
     success: function (response)
     {
       if (FhasDefAcct)
          response.unshift(txtDefaultAccount);

       FAccountSourceOffset=GAccMgrAccountSource.length;
       GAccMgrAccountSource.push(...response);
       if (GisSyncoveryDebug) console.log(GAccMgrAccountSource);
       //for (var idx=0;idx<GAccMgrAccountSource.length;idx++)
       //   console.log(GAccMgrAccountSource[idx]);
     },
     error: function (xhr, status, error)
     {
       alert(txtErrorLoadingAccountList + error);
     }
   });
}

function InternetDlgUpdateAccountList()
{
   if (GisSyncoveryDebug) console.log("InternetDlgUpdateAccountList() in FTP dialog");
   BuildAccountSource();
   if (GisSyncoveryDebug) console.log("clearing comboAccount");
   $("#comboAccount").jqxDropDownList('clear'); // remove all items
   if (GisSyncoveryDebug) console.log("adding items to comboAccount");
   for (const item of GAccMgrAccountSource)
   {
     if (GisSyncoveryDebug) console.log("adding "+item);
     $("#comboAccount").jqxDropDownList('addItem', item);
   }
}

function onInternetDlgAccountSelect(event)
{
   const index=event.args.index;
   HandleCredentialsDeps();

   if (GisSyncoveryDebug) console.log("Internet Dlg Account Select, index: "+index+", FAddAccountIdx="+FAddAccountIdx);

   if (index==FAddAccountIdx)
   {
      GAccDialogShowProtocolIdx=$('#jqxProtocolCombo').jqxDropDownList('getSelectedIndex');
      GAccDialogAddAccountNow=true;
      const shownone=GAccDialogShowProtocolIdx;
      onAccountDialogClosed=function() {
         if (GisSyncoveryDebug) console.log('back from showAccountDialog()');
         InternetDlgUpdateAccountList();
         if (GisSyncoveryDebug) console.log("GAccDialogSavedProtocolIdx: "+GAccDialogSavedProtocolIdx+', shownone: '+shownone);
         if (GisSyncoveryDebug) console.log("GAccDialogSavedAccountIndex: "+GAccDialogSavedAccountIndex);
         if (GisSyncoveryDebug) console.log("FAccountSourceOffset: "+FAccountSourceOffset);
         if (GAccDialogSavedProtocolIdx==shownone)
         {
            if (GAccDialogSavedAccountIndex>0)
            {
               if (GisSyncoveryDebug) console.log("Protocol matches, selecting GAccDialogSavedAccountIndex+FAccountSourceOffset="+
                           (GAccDialogSavedAccountIndex+FAccountSourceOffset));
               $('#comboAccount').jqxDropDownList({selectedIndex:GAccDialogSavedAccountIndex+FAccountSourceOffset});
            }
            else
               if (GisSyncoveryDebug) console.log("GAccDialogSavedAccountIndex too small");
         }
         else
         {
            if (GisSyncoveryDebug) console.log("Protocol does not match");
            $('#comboAccount').jqxDropDownList("selectedIndex",0);
         }
         };
      showAccountDialog();
      return;
   }

   var disableokbutton=((index<FAccountSourceOffset) && (index!=FEnterCredsDirectlyIdx));
   if (GisSyncoveryDebug) console.log("in onInternetDlgAccountSelect, disableokbutton="+disableokbutton+", index: "+index);
   $('#OK_btn3').jqxButton({disabled: disableokbutton});

   if (index>=FAccountSourceOffset)
   {
      const theAccount=GAccMgrAccountSource[index];

      $.ajax({
        url: "/getaccount.php",
        type: "POST",
        data: { protocol: GProtocolNameForGetAccount, name: theAccount, token: GClientToken, info:"none" },
        dataType: "json",
        success: function (response)
        {
           if (GisSyncoveryDebug) console.log("Got: ", response);

           if (FhasCredentials && ($("#inptUsername").length))
           {
              if (GisSyncoveryDebug) console.log("In IntDlg Init, got account "+theAccount+" and setting user="+response.username+
                          " and password="+response.password);
              $("#inptUsername").jqxInput("val",response.username);
              $("#inptPassword").jqxInput("val",response.password);
           }
        },
        error: function (xhr, status, error) {
          alert(txtErrorLoadingAccountDetails + error);
        }
      });
   }
}

function OnProtocolComboItem( ProfileName, InternetProtocolSetRegistryList, ProtocolName, originalItem )
{
   if (GisSyncoveryDebug) console.log('OnProtocolComboItem');
   if (GisSyncoveryDebug) console.log(ProtocolName);
   if (GisSyncoveryDebug) console.log(originalItem);

   var saveduser="";
   var savedpass="";
// Keep Literals   
   if (FhasCredentials && ($("#inptUsername").length))
   {
      saveduser=$("#inptUsername").jqxInput("val");
      savedpass=$("#inptPassword").jqxInput("val");
      if (GisSyncoveryDebug) console.log("In OnProtocolComboItem, saving user="+saveduser+
                  " and password="+savedpass);
   }

   if (!originalItem)
   {
      if (GisSyncoveryDebug) console.log("Looking for "+ProtocolName.toLowerCase()+" in ProtocolComboSource");
      if (GisSyncoveryDebug) console.log("Example: ProtocolComboSource[0].value.toLowerCase() == "+ProtocolComboSource[0].value.toLowerCase());
      const index = ProtocolComboSource.findIndex(item => item.value.toLowerCase() === ProtocolName.toLowerCase());
      if (index>=0)
      {
         if (GisSyncoveryDebug) console.log("found index "+index);
         originalItem=ProtocolComboSource[index];
      }
   }

   if (originalItem)
   {
      Fmngtyp = originalItem.mngtyp;
      Fintname = originalItem.intname;
      if (Fintname==undefined)
         Fintname=originalItem.value;
      FhasDefAcct=originalItem.hasDefAcct;
      FhasCredentials=originalItem.hasCredentials;
      if (GisSyncoveryDebug) console.log("Setting FhasCredentials to "+FhasCredentials);
   }
   else
   {
      if (GisSyncoveryDebug) console.log("no originalItem");
      Fmngtyp="";
      Fintname = ProtocolName;
      FhasDefAcct=true;
      FhasCredentials=false;
   }

   if (GisSyncoveryDebug) console.log('intname:'+Fintname);

   try
   {
     if (GProtocolName != ProtocolName)
     {
        if (GisSyncoveryDebug) console.log("Calling LoadDefaultsToRegistryList with",InternetProtocolSetRegistryList);
        LoadDefaultsToRegistryList(InternetProtocolSetRegistryList, false);
     }
      
     GProtocolName = ProtocolName;

     if (GInternetProtSettingsTabs != null)
     {
        GInternetProtSettingsTabs.jqxTabs( 'destroy' );
        GInternetProtSettingsTabs = null;
     }

      var LBaseProtocolName = GetBaseProtocolName(ProtocolName);

      if (GisSyncoveryDebug) console.log("LBaseProtocolName: "+LBaseProtocolName);

      if (LBaseProtocolName == 'FTP' )
      {
          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_FTP );
          GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });
      }
      else if (LBaseProtocolName == 'SSH' )
      {
          
          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_SFTP );  
          GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });   
      }
      else if (LBaseProtocolName == 'SMB' )
      {
          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_SMB );
          GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });
      }
      else if (LBaseProtocolName == 'HTTP' )
      {

          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_HTTP );  
          GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });   
      }
      else if (LBaseProtocolName == 'Google Drive' ) 
      {
          if (GisSyncoveryDebug) console.log("Loading InternetProtSettingsTabsHTML_GoogleDrive");
          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_GoogleDrive );                       
           GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });   

          $("#ContainerBrowseButton").jqxButton({ theme: GTheme });
          $('#ContainerBrowseButton').off('click');
          $('#ContainerBrowseButton').click(
             function ()
             {
               ApplyInternetSettings(true);
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                 function()
                 {
                    InitDirTreeSelectForm(
                                  $('#Container'),
                                  AssignURLPath, GLeftOrRight,
                                  undefined, // $("#inptInternetFolder"),
                                  'ext://', // URL prefix
                                  true // browse container
                                  );
                 });
             });
          $("#FTPBrowseButton").jqxButton({ theme: GTheme });
          $('#FTPBrowseButton').off('click');
          $('#FTPBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                 function()
                 {
                    InitDirTreeSelectForm(
                                  $('#Container'),
                                  AssignURLPath, GLeftOrRight,
                                  $("#inptInternetFolder"),
                                  'ext://', // URL prefix
                                  false,true // avoid prefix in container field
                                  );
                 });
             });

       }
       else if (LBaseProtocolName == 'GDriveAlike' || LBaseProtocolName == 'GDriveAlikeWithContainer' )
       {
           if (GisSyncoveryDebug) console.log("Loading InternetProtSettingsTabsHTML_GDriveRelevant");
           $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_GDriveRelevant );
           GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });

           if (LBaseProtocolName == 'GDriveAlikeWithContainer')
           {
              $('#lbCont').css({"display":"block"}); // unhide it
              document.getElementById('Container').type = 'text'; // unhide it, change input type from hidden to text

              if (ProtocolName=="Google Cloud Storage")
              {
                 $('#ContainerBrowseButton').css({"display":"none"}); // hide it
                 $('#SettingsButton').css({"display":"block"}); // unhide it
                 $('#SettingsButton').jqxButton({ theme: GTheme });
                 $('#SettingsButton').off('click');
                 $('#SettingsButton').click(ShowGCSDlg);
              }
              else
              {
                 $('#SettingsButton').css({"display":"none"}); // hide it
                 $('#ContainerBrowseButton').css({"display":"inline"}); // unhide it
                 $('#ContainerBrowseButton').jqxButton({ theme: GTheme });
                 $('#ContainerBrowseButton').off('click');
                 $('#ContainerBrowseButton').click(
                    function ()
                    {
                      ApplyInternetSettings(true);
                      PostProfileEditor("***BROWSEDUMMY***", "Browse",
                            function()
                            {
                               InitDirTreeSelectForm(
                                             $('#Container'),
                                             AssignURLPath, GLeftOrRight,
                                             undefined, // $("#inptInternetFolder"),
                                             'ext://', // URL prefix
                                             true // browse container
                                             );
                            });
                    });
              }
           }
           else
           {
              $('#lbCont').css({"display":"none"});
              $('#ContainerBrowseButton').css({"display":"none"}); // hide it
              document.getElementById('Container').type = 'hidden'; // hide it, change input type from hidden to text
              $('#SettingsButton').css({"display":"none"}); // hide it
           }

          $("#FTPBrowseButton").jqxButton({ theme: GTheme });
          $('#FTPBrowseButton').off('click');
          $('#FTPBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                 function()
                 {
                    InitDirTreeSelectForm(
                                  $('#Container'),
                                  AssignURLPath, GLeftOrRight,
                                  $("#inptInternetFolder"),
                                  'ext://', // URL prefix
                                  false,true
                                  );
                 });
             });
       }
       else if (LBaseProtocolName == 'Amazon S3' )
       {          
          
          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_AmazonS3 );            
          GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });   
          $("#ContainerBrowseButton").jqxButton({ theme: GTheme });
          $('#ContainerBrowseButton').off('click');
          $('#ContainerBrowseButton').click(
             function ()
             {
               ApplyInternetSettings(true);
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm(
                                      $('#AmazonS3_bucket'),
                                      AssignURLPath, GLeftOrRight,
                                      undefined, // $("#inptInternetFolder"),
                                      'S3://', // URL prefix
                                      true // browse container
                                      );
                     });
             });
          $("#FTPBrowseButton").jqxButton({ theme: GTheme });
          $('#FTPBrowseButton').off('click');
          $('#FTPBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm(
                                      $('#AmazonS3_bucket'),
                                      AssignURLPath, GLeftOrRight,
                                      $("#inptInternetFolder"),
                                      'S3://', // URL prefix
                                      false,true
                                      );
                     });
             });

       }
       else if (LBaseProtocolName=='Azure')
       {
        
         $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_Azure );  
         GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });   

         if (ProtocolName=='Azure')
         {
            $('#AzureText').css({"display":"block"});
            $('#CacheControlText1').css({"display":"block"});
            $('#CacheControlText2').css({"display":"block"});
            $('#Azure_adv_cache_control').css({"display":"block"});
         }
         else
         {
            $('#AzureText').css({"display":"none"});
            $('#CacheControlText1').css({"display":"none"});
            $('#CacheControlText2').css({"display":"none"});
            $('#Azure_adv_cache_control').css({"display":"none"});
         }


          $("#ContainerBrowseButton").jqxButton({ theme: GTheme });
          $('#ContainerBrowseButton').off('click');
          $('#ContainerBrowseButton').click(
             function ()
             {
               ApplyInternetSettings(true);
               var LPrefix;
               if (ProtocolName=='Azure')
                  LPrefix = 'AZ://';
               else
                  LPrefix = 'ext://';
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm(
                                      $('#Azure_container'),
                                      AssignURLPath, GLeftOrRight,
                                      undefined, // $("#inptInternetFolder"),
                                      LPrefix, // URL prefix
                                      true // browse container
                                      );
                     });
             });
          $("#FTPBrowseButton").jqxButton({ theme: GTheme });
          $('#FTPBrowseButton').off('click');
          $('#FTPBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        var LPrefix;
                        if (ProtocolName=='Azure')
                           LPrefix = 'AZ://';
                        else
                           LPrefix = 'ext://';
                        InitDirTreeSelectForm(
                                      $('#Azure_container'),
                                      AssignURLPath, GLeftOrRight,
                                      $("#inptInternetFolder"),
                                      LPrefix, // URL prefix
                                      false,true
                                      );
                     });
             });


       }
       else if (LBaseProtocolName == 'Sharepoint' )
       {
         $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_Sharepoint );
         GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });
          $("#ContainerBrowseButton").jqxButton({ theme: GTheme });
          $('#ContainerBrowseButton').off('click');
          $('#ContainerBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm(
                                      $('#Sharepoint_domain'),
                                      AssignURLPath, GLeftOrRight,
                                      undefined, // $("#inptInternetFolder"),
                                      'ext://', // URL prefix
                                      true // browse container
                                      );
                     });
             });
          $("#FTPBrowseButton").jqxButton({ theme: GTheme });
          $('#FTPBrowseButton').off('click');
          $('#FTPBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm(
                                      $('#Sharepoint_domain'),
                                      AssignURLPath, GLeftOrRight,
                                      $("#inptInternetFolder"),
                                      'ext://', // URL prefix
                                      false,true
                                      );
                     });
             });

       }
       else if (LBaseProtocolName == 'WebDAV' )
       {
          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_WebDAV );  
          GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });   
            $("#WebDAVBrowseButton").jqxButton({ theme: GTheme });
            $('#WebDAVBrowseButton').off('click');
            $('#WebDAVBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        var Lurl=$("#WebDAV_url").jqxInput('val');
                        var Lprefix='https://';
                        if (Lurl.includes("http://"))
                           Lprefix="http://";
                        alert("Lprefix: "+Lprefix+" because Lurl="+Lurl);
                        InitDirTreeSelectForm($("#WebDAV_url"),
                                              AssignURLPath,
                                              GLeftOrRight,
                                              $("#inptInternetFolder"),
                                              Lprefix);
                     });
             });
       }
       else if (LBaseProtocolName == 'RSync' )
       {
                    
          $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_RSync );  
          GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });        
       }
       else if (LBaseProtocolName == 'Glacier' )
       {
         $("#jqxInternetProtSettingsTabs_div").html( InternetProtSettingsTabsHTML_Glacier );
         GInternetProtSettingsTabs = $('#jqxInternetProtSettingsTabs').jqxTabs({ width: GInternetProtSettingsTabControlWidth, height: GInternetProtSettingsTabControlHeight, keyboardNavigation: false });

         $("#ContainerBrowseButton").jqxButton({ theme: GTheme });
         $('#ContainerBrowseButton').off('click');
         $('#ContainerBrowseButton').click(
            function ()
            {
              ApplyInternetSettings(true);
              PostProfileEditor("***BROWSEDUMMY***", "Browse",
                function()
                {
                   InitDirTreeSelectForm(
                                 $('#Glacier_Vault'),
                                 AssignURLPath, GLeftOrRight,
                                 undefined, // $("#inptInternetFolder"),
                                 'GL://', // URL prefix
                                 true // browse container
                                 );
                });
            });
        }

      $("#btaccmgr").jqxButton({height: 30, width: 30,imgSrc:"images/accmgr48.png",imgWidth:22,imgHeight:22,imgPosition:"center"});
      $("#btaccmgr").on('click', function()
          {
             GAccDialogShowProtocolIdx=$('#jqxProtocolCombo').jqxDropDownList('getSelectedIndex');
             showAccountDialog();
          });

      BuildAccountSource();
      $("#comboAccount").jqxDropDownList({ source: GAccMgrAccountSource, theme: GTheme,
                                           dropDownHeight: 300, selectedIndex: 0,
                                           width: 400, dropDownWidth: 400
                                          });
      if (LBaseProtocolName == 'GDriveAlike' || LBaseProtocolName == 'GDriveAlikeWithContainer' )
      {
         // adjust recursive listing and AvoidChangesAPIInitialListing fields
         if (($("#cbrecursive_listing")).length)
         {
// Convert Literals
            if (HasChangesBasedListing(ProtocolName))
               ($("#recursive_listing_label")).html(txtChangesBasedListingSpeedsUpFolderListing);
            else
            {
               ($("#recursive_listing_label")).html(txtRecursiveListing);
               ($("#cbAvoidChangesAPIInitialListing")).css({"display":"none"});
               ($("#avoidinlabel")).css({"display":"none"});
            }
         }
      }

      if (LBaseProtocolName && (LBaseProtocolName.length>0))
      {
         LoadRegistryListToControls( GInternetProtocolRadioButtonsList, LBaseProtocolName );
         LoadRegistryListToControls( GCurrentInternetProtocolSetRegistryList, LBaseProtocolName );
      }

      // **************** NOW LOAD THE VALUES INTO THE CONTROLS!!! **************************
      if (GisSyncoveryDebug) console.log("Now loading values into the controls");
      LoadRegistryListToControls( GCurrentInternetProtocolSetRegistryList, '*' );

      //LoadRegistryItemToControlByName2( 'cbadv_replace_characters', GCurrentInternetProtocolSetRegistryList, '*');

      if (GisSyncoveryDebug) console.log("GCloudAccountName is: "+GCloudAccountName);

      $('#comboAccount').off('select'); // the following should not cause an event to be triggered

      if (GCloudAccountName && (GCloudAccountName!=undefined) && (GCloudAccountName!==""))
      {
// Keep Literals
         if (GisSyncoveryDebug) console.log("Looking for "+GCloudAccountName+" in account list");
         const accindex = GAccMgrAccountSource.findIndex(item => item.toLowerCase() === GCloudAccountName.toLowerCase());
         if (accindex>=0)
         {
            if (GisSyncoveryDebug) console.log("Found index "+accindex);
            $('#comboAccount').jqxDropDownList("selectedIndex",accindex);
         }
      }
      else
         if (FEnterCredsDirectlyIdx>=0)
            $('#comboAccount').jqxDropDownList("selectedIndex",FEnterCredsDirectlyIdx);
         else
           if (FhasDefAcct)
              $('#comboAccount').jqxDropDownList("selectedIndex",2); // preselect Default Account

      // we don't want this handler too early, it can clear fields especially when FEnterCredsDirectlyIdx is chosen
      $('#comboAccount').on('select', onInternetDlgAccountSelect);

      HandleCredentialsDeps();

      // override storage path related controls. please note this code goes after LoadRegistryListToControls
      // alert('before 2nd big protocol specific ifelseifelseifelseif block, LBaseProtocolName='+LBaseProtocolName);
      if ( LBaseProtocolName == 'FTP' )
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL,GIntProtAbsolutePath]);
          if (Obj != undefined )
          {
            $('#FTP_url').jqxInput('val', 'ftp://' + Obj.server);//Obj.prefix
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }

          CreateCheckBox("cbFTP_secure",200,25,FTP_secure_onchange);
          SetCheckBoxValue("cbFTP_secure",!($("#rbFTPSnone").jqxRadioButton('checked')));

          EnableDisableFTPControls(); //from synaglobals.js

          $("#FTPBrowseButton").jqxButton({ theme: GTheme });
          $('#FTPBrowseButton').off('click');
          $('#FTPBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm($("#FTP_url"), AssignURLPath,
                                              GLeftOrRight,
                                              $("#inptInternetFolder"),
                                              'ftp://');
                     });
             });

      }
      else if (ProtocolName == 'SMB' )
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL,GIntProtAbsolutePath]);

          // alert('SMB: parsing '+GCurrentLeftRightRawURL+', Result='+Obj);

          if (Obj != undefined )
          {
            $('#SMB_url').jqxInput('val', 'smb://' + Obj.server); // Obj.prefix
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }
          else
          {
            $('#SMB_url').jqxInput('val', 'smb://');
            $('#inptPassword').jqxPasswordInput('val', '' );
          }

          $("#SMBBrowseButton").jqxButton({ theme: GTheme });
          $('#SMBBrowseButton').off('click');
          $('#SMBBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm($("#SMB_url"), AssignURLPath,
                                              GLeftOrRight,
                                              $("#inptInternetFolder"),
                                              'smb://');
                     });
             });
      }
      else if (ProtocolName=='Google Drive')
      {          
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );   
          if (Obj != undefined )
          {
            if (Obj.server=='')
               Obj.server='Google Drive'; // default container
            $('#Container').jqxInput('val', Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder);
          }
       }
      else if (LBaseProtocolName=='GDriveAlike')
      {
          if (GCurrentLeftRightRawURL=='')
          {
             GCurrentLeftRightRawURL = 'ext://'+ProtocolName;
             // alert('defaulted URL to '+GCurrentLeftRightRawURL);
          }

          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );
          if (Obj != undefined )
          {
            if (GisSyncoveryDebug) console.log("initializing Container, ProtocolName: "+ProtocolName);
            const cont = ProtocolName==="DropBoxV2" ? "DropBox" : ProtocolName;
            if (GisSyncoveryDebug) console.log("initializing Container, cont: "+cont);
            $('#Container').jqxInput('val', cont); // set (possibly invisible) container field to Protocol Name
            // alert('2nd: setting container to '+ProtocolName+', result='+$('#Container').jqxInput('val'));
            $('#inptInternetFolder').jqxInput('val', Obj.folder);
          }
      }
      else if (LBaseProtocolName=='GDriveAlikeWithContainer')
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );
          if (Obj != undefined )
          {
            if (GisSyncoveryDebug) console.log("initializing Container, ProtocolName: "+ProtocolName+", Obj.server: "+Obj.server);
            const cont = Obj.server==="DropBoxV2" ? "DropBox" : Obj.server;
// Convert Literals
            if (cont=='')
               cont=txtPleaseChooseBucketOr; // default container
            if (GisSyncoveryDebug) console.log("initializing Container, cont: "+cont);

            $('#Container').jqxInput('val', cont);
            $('#inptInternetFolder').jqxInput('val', Obj.folder);
          }
      }
       else if ( LBaseProtocolName == 'SSH' )
       {
          $("#FTPBrowseButton").jqxButton({ theme: GTheme });
          $('#FTPBrowseButton').off('click');
          $('#FTPBrowseButton').click(
             function ()
             {
               ApplyInternetSettings();
               PostProfileEditor("***BROWSEDUMMY***", "Browse",
                     function()
                     {
                        InitDirTreeSelectForm($("#SSH_url"), AssignURLPath,
                                              GLeftOrRight,
                                              $("#inptInternetFolder"),
                                              'sftp://');
                     });
             });

          if (!GisSyncoveryWindows)
          {
             $("#cbrecursive_listing").css({"display":"none"});
             $("#recursive_listing_label").css({"display":"none"});
          }

          $("#btnSSH_Security_Advanced_SSH").jqxButton({ theme: GTheme });
          $("#btnSSH_Security_Advanced_SSH").on('click', MakeAdvancedSSHDialog );

          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL,GIntProtAbsolutePath] );
          if (Obj != undefined )
          {                                               // Obj.prefix
            $('#SSH_url').jqxInput('val', 'sftp://' + Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }
       }
       else if ( LBaseProtocolName == 'Amazon S3' )
       {

          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );  
          if (Obj != undefined )
          {
            $('#AmazonS3_bucket').jqxInput('val', Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }

       }   
       else if ( LBaseProtocolName == 'WebDAV' )
       {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );
          // alert('WebDAV: parsing '+GCurrentLeftRightRawURL+', Result='+Obj);
          if (Obj != undefined )
          {
            $('#WebDAV_url').jqxInput('val', Obj.prefix + Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }
      }
      else if ( LBaseProtocolName == 'Azure' )
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );   
          if (Obj != undefined )
          {
            $('#Azure_container').jqxInput('val', Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }

      }
      else if ( LBaseProtocolName == 'Sharepoint' )
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );
          if (Obj != undefined )
          {
            $('#Sharepoint_domain').jqxInput('val', Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }

      }
      else if ( LBaseProtocolName == 'RSync' )
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );   
          if (Obj != undefined )
          {
            $('#Rsync_url').jqxInput('val', 'rsync://' + Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }
      }
      else if ( LBaseProtocolName == 'Glacier' )
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );   
          if (Obj != undefined )
          {
            $('#Glacier_Vault').jqxInput('val', Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }
      }
      else if ( LBaseProtocolName == 'HTTP' )
      {
          var Obj = GetJSONObject( 'parseftpurl', [GCurrentLeftRightRawURL] );
          if (Obj != undefined )
          {
            $('#HTTP_url').jqxInput('val',  Obj.prefix+ Obj.server);
            $('#inptInternetFolder').jqxInput('val', Obj.folder );
          }
      }

// Keep Literals

   if (FhasCredentials && ($("#inptUsername").length))
   {
      if (GisSyncoveryDebug) console.log("In OnProtocolComboItem, might be restoring user="+saveduser+
                  " and password="+savedpass);
      if (saveduser && saveduser!="")
         $("#inptUsername").jqxInput("val",saveduser);
      if (savedpass && savedpass!="")
         $("#inptPassword").jqxInput("val",savedpass);
   }

   if ((($("#cbrecursive_listing")).length) &&
       ((GProtocolName=="Rackspace") ||
        (GProtocolName=="Sharefile") ||
        (GProtocolName=="SugarSync") ||
        (GProtocolName=="MediaFire") ||
        (GProtocolName=="Mega") ||
        (GProtocolName=="MTP") ||
        (GProtocolName=="EMail")))
   {
       $("#cbrecursive_listing").css({"display":"none"});
       $("#recursive_listing_label").css({"display":"none"});
   }

   var accindex=$("#comboAccount").jqxDropDownList("selectedIndex");

   var disableokbutton=((accindex<FAccountSourceOffset) && (accindex!=FEnterCredsDirectlyIdx));

   if (GisSyncoveryDebug) console.log("in OnProtocolComboItem, disableokbutton="+disableokbutton+", accindex: "+accindex);

   $('#OK_btn3').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme,disabled:disableokbutton});

   if (GisSyncoveryDebug) console.log('End of OnProtocolComboItem');

   }
   catch (err)
   {
      console.log('in function OnProtocolComboItem:');
      console.error(err);
      alert(err.message + ' in function OnProtocolComboItem. Stack: ' + err.stack);
   }
}

function ApplyInternetSettings(ignoreerrors)
{
   var ContainerEmptyError = false;

   GProtocolName=$("#jqxProtocolCombo").jqxDropDownList('val');

   if (GCloudAccountName=$("#comboAccount").jqxDropDownList('getSelectedIndex')==FEnterCredsDirectlyIdx)
      GCloudAccountName="";
   else
      GCloudAccountName=$("#comboAccount").jqxDropDownList('val');

   if (GLeftOrRight == "left")
   {
      //in synapp_profile_editor_form
      GLeftProtocolName = GProtocolName;
      GLeftStoredPath = StoragePathFromControls(GProtocolName,ignoreerrors);
      if (GLeftStoredPath==undefined)
         ContainerEmptyError=true;
      else
         GCurrentLeftRightEdit.jqxInput('val', GLeftStoredPath );
   }
   else if (GLeftOrRight == "right")
   {
      //in synapp_profile_editor_form
      GRightProtocolName = GProtocolName;
      GRightStoredPath = StoragePathFromControls(GProtocolName,ignoreerrors);
      if (GRightStoredPath==undefined)
         ContainerEmptyError=true;
      else
         GCurrentLeftRightEdit.jqxInput('val', GRightStoredPath );
   }

   if (GProtocolName!='SMB')
   {
     var theTimeoutControl = $('#adv_timeout');
     if (theTimeoutControl.length)
        GIPTimeout = theTimeoutControl.jqxFormattedInput('val');

     var theRetriesControl = $('#adv_retries');
     if (theRetriesControl.length)
        GIPRetries = theRetriesControl.jqxFormattedInput('val');
   }

   ControlValuesToRegistryList(GCurrentInternetProtocolSetRegistryList,GetBaseProtocolName(GProtocolName));
   ControlValuesToRegistryList(GCurrentInternetProtocolSetRegistryList,"*");

   GCurrentInternetProtocolSetRegistryList[indexOfListChanged].ListChanged = true;

   if (GLeftOrRight == "adddest")
   {
      GAddDestProtocolName = $("#jqxProtocolCombo").jqxDropDownList('val');
      GProtocolName = GAddDestProtocolName;
      GAddDestStoredPath = StoragePathFromControls(GProtocolName,ignoreerrors);
      if (GAddDestStoredPath==undefined)
         ContainerEmptyError=true;
      else
      {
         RegistryListToObject(GInternetProtocolSetADDDESTRegistryList,GAddDestFTPSettings,GetBaseProtocolName(GProtocolName));
         // alert("After RegistryListToObject: "+ JSON.stringify(GAddDestFTPSettings));
         ApplyAddDestInternetSettings();
      }
   }

   return !ContainerEmptyError;
}

function InitProtocolSettingsForm(ProfileName, InternetProtocolSetRegistryList,
                                  LeftOrRight, ProtocolName, LeftRightEdit, LeftRightRawURL,
                                  WindowToFocusOnClose)
{
  GCurrentInternetProtocolSetRegistryList = InternetProtocolSetRegistryList;
  GSelectedProfileName = ProfileName;
  GLeftOrRight = LeftOrRight;
  GProtocolName = ProtocolName;
  GCurrentLeftRightEdit = LeftRightEdit;
  GReplaceCharactersOKClicked = false;

  var LUpdatedURL = LeftRightEdit.jqxInput('val');
  if (LUpdatedURL=='')
     LUpdatedURL = LeftRightRawURL;

  LeftRightRawURL = LUpdatedURL;
  GCurrentLeftRightRawURL = LUpdatedURL;

  $("#ProtocolSettingsForm_div").html( ProtocolSettingsFormHTML );

  $("#jqxwInternetProtSettingsDlg").jqxWindow({ maxWidth: GInternetProtSettingsDialogWidth, maxHeight: GInternetProtSettingsDialogHeight, height: GInternetProtSettingsDialogHeight,
      width: GInternetProtSettingsDialogWidth,  theme: GTheme,  autoOpen: false,  isModal: true,  animationType: 'none', closeButtonAction: 'close' });

  $('#jqxwInternetProtSettingsDlg').on('close', function (event) {
     GInternetProtDlgOpen=false;

     $('#jqxwInternetProtSettingsDlg').jqxWindow('destroy');
     WindowToFocusOnClose.jqxWindow('focus');
     });

  $('#Cancel_btn3').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#Cancel_btn3').off('click');
  $('#Cancel_btn3').click(function () {
       $('#jqxwInternetProtSettingsDlg').jqxWindow('close');
    });

  $("#jqxProtocolCombo").jqxDropDownList({
    source: ProtocolComboSource,
    displayMember: "label",
    valueMember: "value",
    selectedIndex: 0,
    width: 400,
    dropDownWidth: 400,
    dropDownHeight: 700,
    height: 32,
    renderer: function (index, label, value) {
      const item = ProtocolComboSource[index];
      return `<div style="display: flex; align-items: center; height: 30px; padding: 0 4px;">
                <img src="${item.icon}" style="width: 24px; height: 24px; margin-right: 4px; display: block;">
                <span style="line-height: 16px;">${label}</span>
              </div>`;
    },
    selectionRenderer: function () {
      var selectedIndex=$('#jqxProtocolCombo').jqxDropDownList('getSelectedIndex');
      if (selectedIndex>=0)
      {
        const entry = ProtocolComboSource[selectedIndex];
        return `<div style="display: flex; align-items: center; height: 30px; padding: 0 4px;">
                <img src="${entry.icon}" style="width: 24px; height: 24px; margin-right: 4px; display: block;">
                <span style="line-height: 16px;">${entry.label}</span>
              </div>`;
      }
      else
         return "";
    }
  });


  $("#jqxProtocolCombo").find('input').attr('readonly', 'readonly');

  $('#jqxProtocolCombo').on('select', function (event) {
     var args = event.args;
     if (args != undefined)
     {
         var item = event.args.item;

         if (item!=null)
         {
            OnProtocolComboItem( GSelectedProfileName, GCurrentInternetProtocolSetRegistryList, item.value, item.originalItem );
         }

     }
  });

  $('#OK_btn3').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme,disabled:true}); // start disabled, will be enabled in OnProtocolBlabla

  $('#OK_btn3').off('click');
  $('#OK_btn3').click(
     function ()
     {
       if (ApplyInternetSettings())
          $('#jqxwInternetProtSettingsDlg').jqxWindow('close');
       GInternetProtDlgOpen=false;
     });

  $("#jqxwInternetProtSettingsDlg").jqxWindow('open')

  var LCurrentProtoVal = $("#jqxProtocolCombo").jqxDropDownList('val');

  if (LCurrentProtoVal == GProtocolName)
     OnProtocolComboItem( GSelectedProfileName, GCurrentInternetProtocolSetRegistryList, GProtocolName );
  else
     $("#jqxProtocolCombo").jqxDropDownList( 'val', GProtocolName ); // to cause on('select',...) event

  $('#jqxwInternetProtSettingsDlg').jqxWindow('focus');
  GInternetProtDlgOpen=true;
}


var HTML_GCSDlg =
'<div id="jqxGCSDlg">'+
'<div>Google Cloud Storage Authentication</div>'+
'<div> '+
'<table align="left" style="margin: 0px auto;">'+
'<tr>'+
'  <td valign="top">'+
'   <br>'+
'   <div style="margin-left: 10px;">Syncovery can be authorized via the gcloud command line tools, and/or a Google Cloud Service Account.<br><br>'+
'Please see <a HREF="https://www.syncovery.com/gcs/" target="_blank">the Google Cloud Storage documentation</a> on our web site for more information.<br><br>'+
'Specifying the Service Account Email is optional if you let Syncovery retrieve the access token from the gcloud CLI.'+
'</div><br><br></div>'+

'   <div id="cbUseGCloudCLI" style="margin-left: 10px;">Use the command line "gcloud auth print-access-token" to retrieve the access token for GCS</div>'+
'   <div><br></div>'+
'   <div style="margin-left: 10px;">Service Account Email</div>'+
'   <div style="margin-left: 10px;"><input type="text" id="inptGCSAccount"/></div>'+
'   <div><br></div>'+
'   <div style="margin-left: 10px;">Path to gcloud (optional)</div>'+
'   <div style="margin-left: 10px;"><input type="text" id="inptGCloudPath"/></div>'+
'   <div><br></div>'+
'   <div style="margin-left: 10px;">Scope (optional) such as:<br>https://www.googleapis.com/auth/devstorage.full_control or https://www.googleapis.com/auth/cloud-platform</div>'+
'   <div style="margin-left: 10px;"><input type="text" id="inptGServiceScopes"/></div>'+
'   <br>'+
'     <div style="margin-left: 10px;">Private Key for the Service (if not using the gcloud command line):</div><br>'+
'     <textarea style="margin-left: 10px;" id="inptGCSPrivateKey"></textarea><br><br>'+
'  </td>'+
'</tr>'+
'</table>'+
'<div class="jqx-window-footer-float">'+
'<button id="GCS_OK_btn">OK</button>'+
'<button id="GCS_Cancel_btn">Cancel</button>'+
'</div>'+
'</div>'+
'</div>';



var EncryptionAlgorithmsSource = [
    '3des-cbc', 'blowfish-cbc', 'twofish256-cbc', 'twofish192-cbc',
    'twofish128-cbc', 'aes256-cbc', 'aes192-cbc', 'aes128-cbc',
    'serpent256-cbc', 'serpent192-cbc', 'serpent128-cbc', 'arcfour',
    '(unused)', // TG - was: 'idea-cbc',
    'cast128-cbc', 'none', 'des-cbc',

    'aes128-ctr', 'aes192-ctr', 'aes256-ctr', '3des-ctr', 'blowfish-ctr',
    'twofish128-ctr', 'twofish192-ctr', 'twofish256-ctr',
    'serpent128-ctr', 'serpent192-ctr', 'serpent256-ctr',
    '(unused)', // TG - was: 'idea-ctr',
    'cast128-ctr',

    'arcfour128', 'arcfour256',

    'aes128-gcm', 'aes256-gcm', 'aes128-gcm@openssh.com', 'aes256-gcm@openssh.com',
    'chacha20-poly1305', 'chacha20-poly1305@openssh.com'
      ];
var KeyExchangeAlgorithmsSource = [
    'diffie-hellman-group-exchange-sha1', 'diffie-hellman-group1-sha1',
    'diffie-hellman-group14-sha1', 'diffie-hellman-group-exchange-sha256',
    'rsa1024-sha1', 'rsa2048-sha256',
    'ecdh-sha2-nistp256', 'ecdh-sha2-nistp384', 'ecdh-sha2-nistp521',
    'ecdh-sha2-nistk163', 'ecdh-sha2-nistp192', 'ecdh-sha2-nistp224',
    'ecdh-sha2-nistk233', 'ecdh-sha2-nistb233', 'ecdh-sha2-nistk283',
    'ecdh-sha2-nistk409', 'ecdh-sha2-nistb409', 'ecdh-sha2-nistt571',
    'ecdh-sha2-curve25519',
    'curve25519-sha256@libssh.org', 'curve448-sha512@libssh.org',
    'gss-gex-sha1-', 'gss-group1-sha1-', 'gss-group14-sha1-',
    'diffie-hellman-group14-sha256', 'diffie-hellman-group15-sha512',
    'diffie-hellman-group16-sha512', 'diffie-hellman-group17-sha512',
    'diffie-hellman-group18-sha512'
      ];
var PublicKeyAlgorithmsSource = [
    'ssh-dss', 'ssh-rsa', 'x509v3-sign-rsa', 'x509v3-sign-dss', 'spki-sign-rsa',
    'spki-sign-dss', 'pgp-sign-rsa', 'pgp-sign-dss',
    'ecdsa-sha2-nistp256', 'ecdsa-sha2-nistp384', 'ecdsa-sha2-nistp521',
    'ecdsa-sha2-nistk163', 'ecdsa-sha2-nistp192', 'ecdsa-sha2-nistp224',
    'ecdsa-sha2-nistk233', 'ecdsa-sha2-nistb233', 'ecdsa-sha2-nistk283',
    'ecdsa-sha2-nistk409', 'ecdsa-sha2-nistb409', 'ecdsa-sha2-nistt571',
	  'ecdsa-sha2-curve25519',
    'x509v3-ssh-rsa', 'x509v3-ssh-dss', 'x509v3-rsa2048-sha256',
    'x509v3-ecdsa-sha2-nistp256', 'x509v3-ecdsa-sha2-nistp384', 'x509v3-ecdsa-sha2-nistp521',
    'x509v3-ecdsa-sha2-nistk163', 'x509v3-ecdsa-sha2-nistp192', 'x509v3-ecdsa-sha2-nistp224',
    'x509v3-ecdsa-sha2-nistk233', 'x509v3-ecdsa-sha2-nistb233', 'x509v3-ecdsa-sha2-nistk283',
    'x509v3-ecdsa-sha2-nistk409', 'x509v3-ecdsa-sha2-nistb409', 'x509v3-ecdsa-sha2-nistt571',
    'x509v3-ecdsa-sha2-curve25519',
    'ssh-ed25519', 'ssh-ed448',
    'rsa-sha2-256', 'rsa-sha2-512'
  ];
var MACAlgorithmsListSource = [
    'hmac-sha1', 'hmac-sha1-96', 'hmac-md5', 'hmac-md5-96', 'none',
    'hmac-ripemd160', 'hmac-ripemd', 'hmac-ripemd160@openssh.com',
    'hmac-sha256@ssh.com', 'hmac-sha256-96@ssh.com',
    'umac-32@openssh.com', 'umac-64@openssh.com',
    'umac-96@openssh.com', 'umac-128@openssh.com',
    'hmac-sha2-256', 'hmac-sha2-512',

     'aes128-gcm', 'aes256-gcm', 'chacha20-poly1305@openssh.com',

     'hmac-sha2-256-etm@openssh.com',
     'hmac-sha2-512-etm@openssh.com'
  ];
var SFTPVersionSetSource = [
  'SFTP0',
  'SFTP1',
  'SFTP2',
  'SFTP3',
  'SFTP4',
  'SFTP5',
  'SFTP6'];

function AssignURLPath()
{
 // nothing to do really?

 // var LNewPath = $("#inptInternetFolder").jqxInput( 'val' );

 // GRightStoredPath =  LNewPath;

 // GRightStoredPath =  $("#inptInternetFolder").jqxInput( 'val' );
}


function MakeAdvancedSSHDialog()
{
  EnsureSSHDefaults();
  $("#SSHOptionsDlg_div").html( HTML_SSHOptionsDlg );
  $('#jqxSSHOptionsDlg').jqxWindow({ maxWidth: 1200,  width:1200, maxHeight:650, height:650, autoOpen: false, isModal: true, theme: GTheme, animationType: 'none' });

  $("#inptCompressionLevel_SSH").jqxNumberInput({ width : 40, height : 25,  inputMode: 'simple', decimalDigits: 0, min: 1, max: 9 });
  $("#inptCompressionLevel_SSH").jqxNumberInput( 'val', GCompressionLevel_SSH );
  CreateCheckBox("jqxCompressionLevel_SSH_Cb", 200, 25);
  SetCheckBoxValue("jqxCompressionLevel_SSH_Cb", $("#inptCompressionLevel_SSH").jqxNumberInput( 'val') > 0);


  $("#jqxCompressionLevel_SSH_Cb").on('click', function ()
  {
     if (GetCheckBoxValue("jqxCompressionLevel_SSH_Cb") == false )
     {
        $("#inptCompressionLevel_SSH").jqxNumberInput( 'val', 0 );
        $("#inptCompressionLevel_SSH").jqxNumberInput( 'disabled', true );
     }
     else
       $("#inptCompressionLevel_SSH").jqxNumberInput( 'disabled', false );

  });

 CreateCheckBox("jqxAutoAdjustCiphers_SSH_Cb", 600, 25);
 SetCheckBoxValue("jqxAutoAdjustCiphers_SSH_Cb", G_SSH_AutoAdjustCiphers);

 CreateCheckBox("jqxAutoAdjustTransferBlock_SSH_Cb", 600, 25);
 SetCheckBoxValue("jqxAutoAdjustTransferBlock_SSH_Cb", G_SSH_AutoAdjustTransferBlock);

 $("#inptDownloadBlockSize_SSH").jqxNumberInput({ width : 60, height : 25,  inputMode: 'simple', decimalDigits: 0, value : G_SSH_DownloadBlockSize});
 $("#inptUploadBlockSize_SSH").jqxNumberInput({ width : 60, height : 25,  inputMode: 'simple', decimalDigits: 0, value : G_SSH_UploadBlockSize });
 $("#inptSFTPBufferSize_SSH").jqxNumberInput({ width : 60, height : 25,  inputMode: 'simple', decimalDigits: 0, value : G_SSH_SFTPBufferSize });
 $("#inptPipelineLength_SSH").jqxNumberInput({ width : 60, height : 25,  inputMode: 'simple', decimalDigits: 0, value : G_SSH_PipelineLength });

  $("#jqxEncryptionAlgorithmsListBox").jqxListBox({width: 200, source: EncryptionAlgorithmsSource, checkboxes: true, height: 280, itemHeight: 18});
  $("#jqxEncryptionAlgorithmsListBox").jqxListBox('uncheckAll');
  var items = $("#jqxEncryptionAlgorithmsListBox").jqxListBox('getItems');

  $.each(items,
      function (index)
      {
         if (isOdd(Math.trunc(G_SSH_EncryptionAlgorithms / (2**index))))
            $("#jqxEncryptionAlgorithmsListBox").jqxListBox('checkIndex', index )
      });

$("#jqxKeyExchangeAlgorithmsListBox").jqxListBox({width: 230, source: KeyExchangeAlgorithmsSource, checkboxes: true, height: 280, itemHeight: 18});
$("#jqxKeyExchangeAlgorithmsListBox").jqxListBox('uncheckAll');
var items = $("#jqxKeyExchangeAlgorithmsListBox").jqxListBox('getItems');

$.each(items, function (index) {
  if (isOdd(Math.trunc(G_SSH_KeyExchangeAlgorithms / (2**index))))
     $("#jqxKeyExchangeAlgorithmsListBox").jqxListBox('checkIndex', index ); });

  $("#jqxPublicKeyAlgorithmsListBox").jqxListBox({width: 250, source: PublicKeyAlgorithmsSource, checkboxes: true, height: 280, itemHeight: 18});

  $("#jqxPublicKeyAlgorithmsListBox").jqxListBox('uncheckAll');
  var items = $("#jqxPublicKeyAlgorithmsListBox").jqxListBox('getItems');
  $.each(items, function (index) {
    if (isOdd(Math.trunc(G_SSH_PublicKeyAlgorithms / (2**index))))
       $("#jqxPublicKeyAlgorithmsListBox").jqxListBox('checkIndex', index ); });

  $("#jqxMACAlgorithmsListBox").jqxListBox({width: 220, source: MACAlgorithmsListSource, checkboxes: true, height: 280, itemHeight: 18});
  $("#jqxMACAlgorithmsListBox").jqxListBox('uncheckAll');
  var items = $("#jqxMACAlgorithmsListBox").jqxListBox('getItems');
  $.each(items, function (index) {
    if (isOdd(Math.trunc(G_SSH_MACAlgorithms / (2**index))))
       $("#jqxMACAlgorithmsListBox").jqxListBox('checkIndex', index ); });

  $("#jqxSFTPVersionSetListBox").jqxListBox({width: 100, source: SFTPVersionSetSource, checkboxes: true, height: 280, itemHeight: 18});
  $("#jqxSFTPVersionSetListBox").jqxListBox('uncheckAll');
  var items = $("#jqxSFTPVersionSetListBox").jqxListBox('getItems');
  $.each(items, function (index) {
    if (isOdd(Math.trunc(G_SSH_SFTPVersionSet / (2**index))))
       $("#jqxSFTPVersionSetListBox").jqxListBox('checkIndex', index ); });

  $("#SSHOptions_Close_btn").jqxButton();
  $("#SSHOptions_Close_btn").on('click', function ()
  {

     var A_SSH_EncryptionAlgorithms = 0;
     var items = $("#jqxEncryptionAlgorithmsListBox").jqxListBox('getItems');

     $.each(items, function (index)
       {
         var item = $("#jqxEncryptionAlgorithmsListBox").jqxListBox('getItem', index );
         if (item.checked)
         {
            A_SSH_EncryptionAlgorithms = A_SSH_EncryptionAlgorithms + (2 ** index);
            //alert("Added "+item.label+" at idx "+index+", 2^idx="+ (2 ** index).toString(16) + " -> " +
            //      A_SSH_EncryptionAlgorithms.toString(16));
         }
       });

     G_SSH_EncryptionAlgorithms = A_SSH_EncryptionAlgorithms;

     //alert("SSHAlg= " + G_SSH_EncryptionAlgorithms.toString(16));

     var A_SSH_KeyExchangeAlgorithms = 0;
     var items = $("#jqxKeyExchangeAlgorithmsListBox").jqxListBox('getItems');
     $.each(items, function (index) {
         var item = $("#jqxKeyExchangeAlgorithmsListBox").jqxListBox('getItem', index );
         if (item.checked == true )
         {
             A_SSH_KeyExchangeAlgorithms = A_SSH_KeyExchangeAlgorithms + (2 ** index);
         }

       });

     G_SSH_KeyExchangeAlgorithms = A_SSH_KeyExchangeAlgorithms.toString();


     var A_SSH_PublicKeyAlgorithms = 0;
     var items = $("#jqxPublicKeyAlgorithmsListBox").jqxListBox('getItems');
     $.each(items, function (index) {
         var item = $("#jqxPublicKeyAlgorithmsListBox").jqxListBox('getItem', index );
         if (item.checked == true )
         {
             A_SSH_PublicKeyAlgorithms = A_SSH_PublicKeyAlgorithms + (2 ** index);
         }

       });

     G_SSH_PublicKeyAlgorithms = A_SSH_PublicKeyAlgorithms.toString();

     var A_SSH_MACAlgorithms = 0;
     var items = $("#jqxMACAlgorithmsListBox").jqxListBox('getItems');
     $.each(items, function (index) {
         var item = $("#jqxMACAlgorithmsListBox").jqxListBox('getItem', index );
         if (item.checked == true )
         {
             A_SSH_MACAlgorithms = A_SSH_MACAlgorithms + (2 ** index);
         }
       });

     G_SSH_MACAlgorithms = A_SSH_MACAlgorithms.toString();

     var A_SSH_SFTPVersionSet = 0;
     var items = $("#jqxSFTPVersionSetListBox").jqxListBox('getItems');
     $.each(items, function (index) {
         var item = $("#jqxSFTPVersionSetListBox").jqxListBox('getItem', index );
         if (item.checked == true )
         {
             A_SSH_SFTPVersionSet = A_SSH_SFTPVersionSet + (2 ** index);
         }
       });

     G_SSH_SFTPVersionSet = A_SSH_SFTPVersionSet.toString();
     GCompressionLevel_SSH = $("#inptCompressionLevel_SSH").jqxNumberInput( 'val' );
     G_SSH_AutoAdjustCiphers = GetCheckBoxValue('jqxAutoAdjustCiphers_SSH_Cb');
     G_SSH_AutoAdjustTransferBlock = GetCheckBoxValue('jqxAutoAdjustTransferBlock_SSH_Cb');

     G_SSH_DownloadBlockSize = $("#inptDownloadBlockSize_SSH").jqxNumberInput('val');
     G_SSH_UploadBlockSize = $("#inptUploadBlockSize_SSH").jqxNumberInput('val');
     G_SSH_SFTPBufferSize = $("#inptSFTPBufferSize_SSH").jqxNumberInput('val');
     G_SSH_PipelineLength = $("#inptPipelineLength_SSH").jqxNumberInput('val');

     $('#jqxSSHOptionsDlg').jqxWindow('close');
  });

  $('#jqxSSHOptionsDlg').jqxWindow('open');

} // MakeAdvancedSSHDialog


function ShowGCSDlg(event)
{
  $("#HTML_GCSDlg_div").html( HTML_GCSDlg );
  $('#jqxGCSDlg').jqxWindow({ maxWidth: 10000,  width: 800, maxHeight:10000, height:730,
                              autoOpen: false, isModal: true,
                              theme: GTheme, animationType: 'none',
                              draggable: true });

  $("#inptGCSAccount").jqxInput({ width: 600, height: 25});
  $("#inptGCloudPath").jqxInput({ width: 600, height: 25});
  $("#inptGServiceScopes").jqxInput({ width: 600, height: 25});
  $("#inptGCSPrivateKey").jqxInput({ width: 720, height: 250});

  // empty the fields first
  $("#inptGCSAccount").jqxInput('val', "");
  $("#inptGCloudPath").jqxInput('val', "");
  $("#inptGServiceScopes").jqxInput('val', "");
  $("#inptGCSPrivateKey").jqxInput('val', "");
  CreateCheckBox("cbUseGCloudCLI", 600, 25);

// Convert Literals

  var AccountID=$("#comboAccount").jqxDropDownList('val');
  if ((AccountID==txtDefaultAccount) ||
      (AccountID=='Default Account') ||
      (AccountID=='Standardkonto') ||
      (AccountID=='Compte par défaut'))
     AccountID="";

  // get PK from Syncovery
  var getparams = { };
  getparams.ProfileName = GSelectedProfileName;
  getparams.token = GClientToken;
  getparams.ac=AccountID;
  getparams.get="true";
  var getjson = JSON.stringify(getparams);

  $.post("post_gcsdetails.php",getjson).done(function(data)
  {
     var EM=data.em;
     var PK=data.pk;
     var GC=(data.gc == "true");
     var GP=data.gp;
     var SC=data.sc;
     $("#inptGCSAccount").jqxInput('val', EM);
     $("#inptGCSPrivateKey").jqxInput('val', PK);
     $("#inptGCloudPath").jqxInput('val', GP);
     $("#inptGServiceScopes").jqxInput('val', SC);
     SetCheckBoxValue("cbUseGCloudCLI", GC);
  });

  $('#GCS_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#GCS_OK_btn').off('click');
  $('#GCS_OK_btn').click(function ()
  {
     var PK = $("#inptGCSPrivateKey").jqxInput('val');
     var EM = $("#inptGCSAccount").jqxInput('val');
     var GC = GetCheckBoxValue("cbUseGCloudCLI");
     var GP = $("#inptGCloudPath").jqxInput('val');
     var SC = $("#inptGServiceScopes").jqxInput('val');

     // send PK to Syncovery
     var sendparams = { };
     sendparams.ProfileName = GSelectedProfileName;
     sendparams.token = GClientToken;
     sendparams.ac=AccountID;
     sendparams.pk=PK;
     sendparams.em=EM;
     sendparams.gc=GC;
     sendparams.gp=GP;
     sendparams.Sc=SC;
     var json = JSON.stringify(sendparams);

     $.post( "post_gcsdetails.php", json ).done(function( data )
     {
       if (data != 'OK' )
          alert( txtErrorSavingData + data);
     });

     $('#jqxGCSDlg').jqxWindow('close');
  });

  $('#GCS_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
  $('#GCS_Cancel_btn').off('click');
  $('#GCS_Cancel_btn').click(function () {
      $('#jqxGCSDlg').jqxWindow('close');
  });

  $('#jqxGCSDlg').jqxWindow('open');
};


