// 'use strict'; does not work, breaks directory selection form

var GAccountDlgInitialized=false;
    GButtonIsStopScheduler=null; // button caption not set yet
    GAddRowButtonFocusedOnce=false;

var RenameProfileHTML =
  "<div id='jqxRenameProfileDlg'>"+
  "<div>Enter New Profile Name</div>"+
  "<div> "+
  "<table id='container'>"+
  "<tr>"+
  "<td valign='top'>"+
  "    <div style='margin-left: 20px;'></div>"+
  "    <div style='margin-left: 20px;'></div>"+
  "    <div style='margin-left: 20px;'>"+
  "      <table>"+
  "         <tr>"+
  "            <td>"+
  "              <div><input type='text' id='inpt_ProfileName'  style='float: left;' ></input></div>"+
  "            </td>"+
  "            <td>"+
  "                <button id='RenameProfile_OK_btn'>OK</button>"+
  "            </td>"+
  "            <td>"+
  "                <button id='RenameProfile_Cancel_btn'>Cancel</button>"+
  "            </td>"+
  "         </tr>"+
  "      </table>"+
  "    </div>"+
  "</td>"+
  "</tr>"+
  "</table>"+
  "</div>"+
  "</div>";

var ImportProfilesHTML =
  '<div id="jqxImportProfilesDlg">'+
  '<div>Import Profiles</div>'+
  '<div>'+
  '<div>Click the Browse button to choose the file to upload and import.</div>'+
  '<br>'+
  '<div>The supported file types are: xml, csv, ini, cfg, log.</div>'+
  '<br>'+
  '<div>If a file contains several profiles, all profiles will be imported.</div>'+
  '<br>'+
  '<div>When uploading several files, you will see a separate confirmation message for each file.</div>'+
  '<br>'+
  '<div id="jqxFileUpload"></div>'+
  '<br>'+
  '<div><button id="ImportProfilesOKBtn">Close</button></div>'+
  '</div>';

var ImportBinCompResultsHTML =
  '<div id="jqxImportBinCompResultsDlg">'+
  '<div>Import Binary Comparion Results from a Log File</div>'+
  '<div>'+
  '<div>Click the Browse button to choose the file to upload and import.</div>'+
  '<br>'+
  '<div>The supported file type is: .log.</div>'+
  '<br>'+
  '<div>Please upload only one file at a time and wait for the import to complete before using the web GUI for other tasks.</div>'+
  '<br>'+
  '<div id="jqxFileUploadBinComp"></div>'+
  '<br>'+
  '<div><button id="ImportBinCompResultsOKBtn">Close</button></div>'+
  '</div>';

var GridSource =
{
    datatype: "json",
    datafields: [
        { id: 'id', type:'number' },
//        { name: 'Group', type: 'string' },
        { name: 'Name', type: 'string' },
        { name: 'HTMLName', type: 'string' },
        { name: 'LeftPath', type: 'string' },
        { name: 'RightPath', type: 'string' },
        { name: 'Progress', type: 'string' },
        { name: 'direction', type: 'string' },
        { name: 'isDisabled', type: 'boolean' },
        { name: 'isLocked', type: 'boolean' },
        { name: 'isScheduled', type: 'boolean' },
        { name: 'ranFine', type: 'boolean' },
        { name: 'hadError', type: 'boolean' },
        { name: 'isRunning', type: 'boolean' },

        { name: 'Comment', type: 'string' },
        { name: 'LastRun', type: 'string' },
        { name: 'NextRun', type: 'string' }
        ],
          addrow: function (rowid, rowdata, position, commit) {
          // synchronize with the server - send insert command
          // call commit with parameter true if the synchronization with the server is successful
          //and with parameter false if the synchronization failed.
          // you can pass additional argument to the commit callback which represents the new ID if it is generated from a DB.
            commit(true);
          },

          deleterow: function (rowid, commit)
          {
            // synchronize with the server - send delete command
            // call commit with parameter true if the synchronization with the server is successful
            // and with parameter false if the synchronization failed.

            // this causes duplicate invocation of DeleteProfile!!
            // DeleteProfile();

          },
    root: "Rows",
    id: 'id',
    url: "profiles.json",
    filter: function ()
    {
       //update the grid and send a request to the server.
       $("#jqxgrid").jqxGrid('updatebounddata');
       GProfileListChanged = true;
    },
                
    beforeprocessing: function (data)
    {
      GridSource.totalrecords = data[1].TotalRows;
    }
};

var GridDataAdapter = new $.jqx.dataAdapter(GridSource,
{
  downloadComplete: function (data, status, xhr) { },
  loadComplete:
     function (data)
     {
       if (GisSyncoveryDebug) console.log("Profile List loaded");
       if (!GAddRowButtonFocusedOnce)
          FocusAddRowButton();
     },
  loadError: function (xhr, status, error) {
    if (GisSyncoveryDebug) console.log("Profile list loading error:", error);
    alert("Profile list loading error:" + error);
  },
                
  beforeSend: function (xhr) {
     xhr.setRequestHeader('token', GClientToken);
  }
});

var GLastFilterSent="";
    GSentLastUsedIndex=0;
    GLastScheduledCBState=false;

function RefreshMainGrid()
{
    // var scrolling = $("#jqxgrid").jqxGrid("scrolling");
    $("#jqxgrid").jqxGrid('updatebounddata', 'cells');
    GProfileListChanged = true;
}

function FocusAddRowButton()
{
  if (GisSyncoveryDebug) console.log("Focusing add row button");
  $("#addrowbutton").attr("tabindex", "0").focus();
  GAddRowButtonFocusedOnce=true;
}

function RefreshGrid()
{
  var CurrentFilter = $("#inpt_Filter").jqxInput('val');
  var CurrentLastUsedIndex =$("#jqxLastUsedCombo").jqxDropDownList('selectedIndex');
  var CurrentSchedState=$("#jqxShowScheduledCB").jqxCheckBox('val');

  if ((CurrentFilter != GLastFilterSent) ||
      (CurrentLastUsedIndex != GSentLastUsedIndex) ||
      (CurrentSchedState != GLastScheduledCBState))
     $("#jqxgrid").jqxGrid('gotopage', 0);

  GLastFilterSent = CurrentFilter;
  GSentLastUsedIndex = CurrentLastUsedIndex;
  GLastScheduledCBState = CurrentSchedState;

  GridSource.url = "profiles.json?filter="+GLastFilterSent+"&schonly="+GLastScheduledCBState+"&lastused="+GSentLastUsedIndex;

  $("#jqxgrid").jqxGrid({source: GridDataAdapter });

  GProfileListChanged = true;
}


function RenameProfile(ADuplicate)
{
   var selectedRow = $('#jqxgrid').jqxGrid('getselectedrowindex');
   if (selectedRow == -1) return;
   var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedRow).Name;

   $("#RenameProfileDlg_div").html(RenameProfileHTML);
   $('#jqxRenameProfileDlg').jqxWindow({ maxWidth: 640,  width:640, maxHeight:80, height:80, autoOpen: false, isModal: true,
     theme: GTheme, animationType: 'slide' });

   $("#inpt_ProfileName").jqxInput({width: 400,  height: 25, value: SelectedProfile});


   $('#RenameProfile_OK_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
   $('#RenameProfile_OK_btn').off('click');
   $('#RenameProfile_OK_btn').click(function () {
      var NewProfileName = $("#inpt_ProfileName").jqxInput('val');
      var sendparams = { };
      sendparams.OldProfileName = SelectedProfile;
      sendparams.NewProfileName = NewProfileName.trim();
      sendparams.token = GClientToken;
      sendparams.duplicate = ADuplicate;
      if (GisSyncoveryDebug) console.log(sendparams);
      var json = JSON.stringify(sendparams);

      $.post("post_rename_profile.php", json).done(function(data)
      {
        if (data == 'OK')
        {

           $("#jqxgrid").jqxGrid({source: GridDataAdapter });
           GProfileListChanged = true;
           $('#jqxgrid').jqxGrid('clearselection');
        }
        else
        {
           alert("Profile was not " + (ADuplicate ? "duplicated" : "renamed") + ": " + data);
        }
      });


      $('#jqxRenameProfileDlg').jqxWindow('close');
    });

   $('#RenameProfile_Cancel_btn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
   $('#RenameProfile_Cancel_btn').off('click');
   $('#RenameProfile_Cancel_btn').click(function () {
       $('#jqxRenameProfileDlg').jqxWindow('close');
       });

   $('#jqxRenameProfileDlg').jqxWindow('open');
}

function ImportProfiles()
{
   $("#ImportProfilesDlg_div").html(ImportProfilesHTML);
   $('#jqxImportProfilesDlg').jqxWindow({ maxWidth: 580,  width:400, maxHeight:800, height:400, autoOpen: false, isModal: true,
           theme: GTheme, animationType: 'slide' });

   $('#jqxFileUpload').jqxFileUpload({ width: 300, uploadUrl: 'profileimport.php?token='+GClientToken, fileInputName: 'fileToUpload'});

   $('#ImportProfilesOKBtn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
   $('#ImportProfilesOKBtn').off('click');
   $('#ImportProfilesOKBtn').click(function () {
     $('#jqxImportProfilesDlg').jqxWindow('close');
     RefreshMainGrid();
     });

   $('#jqxImportProfilesDlg').jqxWindow('open');
}

function ImportBinCompResults()
{
   var Lprofname = GetSelectedProfileName();

   if (Lprofname == "")
   {
      alert("Please choose a profile to import the binary comparison results into.");
      return;
   }

   $("#ImportBinCompResultsDlg_div").html(ImportBinCompResultsHTML);
   $('#jqxImportBinCompResultsDlg').jqxWindow({ maxWidth: 580,  width:400, maxHeight:800, height:400, autoOpen: false, isModal: true,
           theme: GTheme, animationType: 'slide' });

   $('#jqxFileUploadBinComp').jqxFileUpload({ width: 300, uploadUrl: 'bincompresultsimport.php?token='+GClientToken+
                                         '&profilename='+Lprofname,
//                                         multipleFilesUpload: false, does not work
                                         fileInputName: 'fileToUpload'});

   $('#ImportBinCompResultsOKBtn').jqxButton({height: GBtnHeight, width: GBtnWidth,theme: GTheme});
   $('#ImportBinCompResultsOKBtn').off('click');
   $('#ImportBinCompResultsOKBtn').click(function () {
     $('#jqxImportBinCompResultsDlg').jqxWindow('close');
     RefreshMainGrid();
     });

   $('#jqxImportBinCompResultsDlg').jqxWindow('open');
}


function checkeventsuccess(data)
{
  if (data != undefined)
  {
    if (data.error == 'session_expired')
    {
        location.reload();
        return;
    }

    var Lstate = data.scheduler_state;

    var Lmsg = data.scheduler_msg;
    var Lalert= data.show_alert;
    var Lsrvtime = data.srvtime;

    if ((Lalert != "") && (Lalert != "undefined") && (Lalert != undefined))
    {
       if (Lalert.startsWith("OPENURL:"))
       {
          alert("Please enable pop-ups, we will now try to open a new tab or window");
          window.open(Lalert.substring(8,10000));
       }
       else
       {
         if (data.is_question=="true")
         {
            var replyval = confirm(Lalert);

            var Lmsg_id = data.msg_id;
            var sendparams = { };
            sendparams.token = GClientToken;
            sendparams.msg_id = Lmsg_id;
            sendparams.msg_reply = replyval;
            var json = JSON.stringify(sendparams);

            $.post('msgreply.php', json);
         }
         else
            alert(Lalert);
       }
    }

    //alert("Number of rows on current page: " + paginginformation.pagesize);
    var updatecount = 0;

    if (data.profiles != undefined)
    {
      var datainformation = $('#jqxgrid').jqxGrid('getdatainformation');
      for (var j = 0; j < datainformation.rowscount; j++)
      {
        for (var i = 0; i < data.profiles.length; i++)
        {
           var obj = data.profiles[i];
           if ($("#jqxgrid").jqxGrid('getcellvalue', j, 'Name') == obj.name)
          {
            if (obj.progress != "")
              {
                var oldval=$("#jqxgrid").jqxGrid('getcellvalue', j, 'Progress');

                if ((// true || // don't protect "Starting"
                     (oldval != '<b>Starting...</b>') ||
                     (GLastProfileStartedAt<=GetTickCount()-1000) || // protect "Starting" only for one second, quick profiles may already be finished
                     (obj.progress.indexOf('<b')>=0) ||
                     (obj.progress.indexOf('<B')>=0) ||
                     (obj.progress.indexOf('<a')>=0) ||
                     (obj.progress.indexOf('<A')>=0)) &&
                    (obj.progress != oldval))
                   $("#jqxgrid").jqxGrid('setcellvalue', j, 'Progress', obj.progress);

                if ((obj.lastRun!=undefined) && (obj.lastRun!="") && 
		            (obj.lastRun!=$("#jqxgrid").jqxGrid('getcellvalue', j, 'LastRun')))
                   $("#jqxgrid").jqxGrid('setcellvalue', j, 'LastRun', obj.lastRun);

                if ((obj.nextRun!=undefined) && (obj.nextRun!="") &&
 		            (obj.nextRun!=$("#jqxgrid").jqxGrid('getcellvalue', j, 'NextRun')))
                   $("#jqxgrid").jqxGrid('setcellvalue', j, 'NextRun', obj.nextRun);

                updatecount++;
              }
              break;
           }
        }
      }
      //Lmsg = ('updatecount='+updatecount+', rowscount='+datainformation.rowscount);
    }
    //else
    //   Lmsg = 'data.profiles=undefined';

    if ((Lmsg==undefined) || (Lmsg=="undefined"))
       Lmsg = "Logged out - please refresh page to log in";

    // console.log('Setting title grid');
    $("#titlegrid").jqxGrid(
    {
       columns: [
         { text: "&nbsp;<b>"+GSyncoveryTitle+"</b>"+GLicenseMsgBR+GLicenseMsg, width: cTitleGridCol1Width },
         { text: "<b>"+Lmsg+"</b>", width: cTitleGridCol2Width },
         { text: Lsrvtime, width: cTitleGridCol3Width, align: 'center' }
         ]
    });

    const isrunning=data.scheduler_state == 'Running';

    if (GButtonIsStopScheduler!=isrunning)
    {
	     if (isrunning)
	     {
	        if (GisSyncoveryDebug) console.log('Setting scheduler button caption to Stop');
	        var $btn = $('#start_scheduler_button');
	        $btn.jqxButton('val', 'Stop');
	        $btn.attr('title', 'Stop Scheduler');
	     }
	     else
	     {
	        if (GisSyncoveryDebug) console.log('Setting scheduler button caption to Start');
	        var $btn = $('#start_scheduler_button');
	        $btn.jqxButton('val', 'Start')
	        $btn.attr('title', 'Start Scheduler');
	     }
      GButtonIsStopScheduler=isrunning;
    }
  }
}

function checkeventerror(jqXHR,textStatus,errorThrown)
{
   $("#titlegrid").jqxGrid(
   {
      columns: [
        { text: "&nbsp;<b>"+GSyncoveryTitle+"</b>"+GLicenseMsgBR+GLicenseMsg, width: cTitleGridCol1Width },
        { text: "<b>Syncovery WebServer unavailable: "+textStatus+' '+errorThrown+"</b>", width: cTitleGridCol2Width },
        { text: "", width: cTitleGridCol3Width }
        ]
   });
}

function showstatusmessage(textStatus)
{
   console.log(textStatus);
   $("#titlegrid").jqxGrid(
   {
      columns: [
        { text: "&nbsp;<b>"+GSyncoveryTitle+"</b>"+GLicenseMsgBR+GLicenseMsg, width: cTitleGridCol1Width },
        { text: textStatus, width: cTitleGridCol2Width },
        { text: "", width: cTitleGridCol3Width }
        ]
   });
}

function CheckForEventFunc()
{
  if (GLicenseMsg != '')
     $("#titlegrid").jqxGrid('setcellvalue', j, 'LastRun', GLicenseMsg)

  var CurrentFilter = $("#inpt_Filter").jqxInput('val');
  var CurrentScheduledOnly=$("#jqxShowScheduledCB").jqxCheckBox('val');
  var CurrentLastUsedIndex =$("#jqxLastUsedCombo").jqxDropDownList('selectedIndex');

  if ((CurrentFilter != GLastFilterSent) ||
      (CurrentLastUsedIndex != GSentLastUsedIndex) ||
      (CurrentScheduledOnly != GLastScheduledCBState))
  {
     RefreshGrid();
     return;
  }


  var scrolling = $("#jqxgrid").jqxGrid('scrolling');

  if (scrolling.vertical == false)
  {
    var Profiles;

    var rows = $("#jqxgrid").jqxGrid('getrows');
    var datainfo = $("#jqxgrid").jqxGrid('getdatainformation');
    var paginginfo = datainfo.paginginformation;
    var startrow = paginginfo.pagenum  * paginginfo.pagesize;
    var endrow = startrow + paginginfo.pagesize;

    if (GProfileListChanged)
    {
       Profiles = "";
       for (var j=0; j<rows.length; j++)
         Profiles += '"' + rows[j].Name  + '",';
       GProfileListChanged = false;
    }
    else
       Profiles = "*"; // means same as in previous call

    var forceprogress=false;
    for (var j=0; j<rows.length; j++)
      if ($("#jqxgrid").jqxGrid('getcellvalue', j, 'Progress')=='<b>Starting...</b>')
         forceprogress=true;

    var sendparams = { };
    sendparams.token = GClientToken;
    sendparams.profiles = Profiles;
    sendparams.forceprogress = forceprogress;
    sendparams.ReadyForUIMsg = "true";
    var json = JSON.stringify(sendparams);

    $.ajax({async: true,
        type: "POST",
        url:"post_checkforevent.php",
        data: json,
        contentType: "application/json",
        dataType: "json",
        success: checkeventsuccess,
        error: checkeventerror});
  }
}

function showAccountDialog()
{
  if (!GAccountDlgInitialized)
     $("#dialogContainer").load("AccountManager.html", function ()
     {
       showAccountDialog(); // Call the init function defined inside the HTML file
     });
  else
     showAccountDialog();
}

InitMainForm = function()
{
  //showAccountDialog();
  //return;

  var MainFormHTML = MainFormHTMLPart1;

  if (GLicenseMsg.substring(0,12)=='Limited Free')
     MainFormHTML = MainFormHTML+
                    "<div><p style='font-family: Verdana,Arial,sans-serif;font-size: 13px;margin-left: 8px;margin-top: 8px;margin-bottom: 8px;'>"+
                    "Please see <a HREF='https://www.syncovery.com/freelinuxedition/' target='_blank' rel='noopener'>our web site</a> for details about licensing Syncovery and the Limited Free Edition."+
                    "</p></div>";

  MainFormHTML = MainFormHTML + MainFormHTMLPart2;

  $("#MainForm_div").html(MainFormHTML);

  // initialize jqxGrid
  var contextMenu = $("#jqxMenu").jqxMenu({width: 220, height: GContextMenuHeight, autoOpenPopup: false, mode: 'popup'});

  // open the context menu when the user presses the mouse right button.


  $('#jqxMenu').on('itemclick', function (event)
  {
    // get the clicked LI element.
    if ($(event.target).text() == "Edit Profile")
    {
        setTimeout(EditSelectedProfile, 100);
    }
    else if ($(event.target).text() == "Add New Profile")
    {
        AddProfile();
    }
    else if ($(event.target).text() == "Delete Profile")
    {
       DeleteProfile();
    }
    else if ($(event.target).text() == "Rename Profile")
    {
       RenameProfile(false);
    }
    else if ($(event.target).text() == "Duplicate Profile")
    {
       RenameProfile(true);
    }
    else if ($(event.target).text() == "Enable Profile")
    {
       EnableDisableProfile(true);
    }
    else if ($(event.target).text() == "Disable Profile")
    {
       EnableDisableProfile(false);
    }
    else if ($(event.target).text() == "Resume Profile")
    {
       PauseResumeProfile(true);
    }
    else if ($(event.target).text() == "Pause Profile")
    {
       PauseResumeProfile(false);
    }
    else if ($(event.target).text() == "Lock Profile Settings")
    {
       LockProfile(true);
    }
    else if ($(event.target).text() == "Unlock Profile Settings")
    {
       LockProfile(false);
    }
    else if ($(event.target).text() == "Run Unattended")
    {
       RunSelectedProfile(false);
    }
    else if ($(event.target).text() == "Run With Preview")
    {
       RunSelectedProfile(true);
    }
    else if ($(event.target).text() == "Stop Profile")
    {
       StopSelectedProfile();
    }
    else if ($(event.target).text() == "Diagnose Activity")
    {
       DiagnoseActivity();
    }
    else if ($(event.target).text() == "Dump Memory Usage")
    {
       DumpMemoryUsage();
    }
    else if ($(event.target).text() == "Show Detailed Status")
    {
       ShowDetailedStatus();
    }
    else if ($(event.target).text() == "Import Profiles")
    {
       ImportProfiles();
    }
    else if ($(event.target).text() == "Import Binary Comparison Results From Log")
    {
       ImportBinCompResults();
    }
    else if ($(event.target).text() == "Export Profile")
    {
       ExportProfile();
    }
    else if ($(event.target).text() == "Export All Profiles")
    {
       ExportProfiles();
    }
    else if ($(event.target).text() == "Terminate Process")
    {
       if (GisSyncoveryWindows)
          alert('Terminating from web GUI not supported.');
       else
          TerminateProcess();
    }
    else
       alert("Unrecognized choice: "+$(event.target).text());
  });

  var imagerenderer = function (row)
  {
    const rec=GridDataAdapter.records[row];

	   const icons = [];

	   if (rec.isScheduled) icons.push('🕒');
	   if (rec.ranFine) icons.push('✅');
	   if (rec.hadError) icons.push('⚠️');
	   if (rec.isRunning) icons.push('▶️');
	   if (rec.isDisabled) icons.push('🚫');
	   if (rec.isLocked) icons.push('🔒');

    var txtcomment="";

    if (rec.Comment && (rec.Comment>""))
    {
	      icons.push('ℹ️');
       txtcomment=' title="'+rec.Comment+'"';
    }

    const txtic=icons.join(' ');

    const marg=(icons.length == 1) ? 14 : ((icons.length == 2) ? 6 : 0);

    return '<div class="jqx-grid-cell-left-align" '+txtcomment+'style="margin-top: '+marg+'px;">'+
           '<big>'+txtic+'</big>'+
           '</div>';
  }

  /*
  const namerenderer= function (row, datafield, value)
  {
    const rec=GridDataAdapter.records[row];
    var res=value;
    if (rec.Comment && (rec.Comment>""))
       res='<div title="'+rec.Comment+'" style="margin: 4px;">' + res + '</div>';
    return res;
  }
  */

  var directionrenderer = function (row, datafield, value)
  {
     if (GridDataAdapter.records &&
        GridDataAdapter.records[row] &&
        GridDataAdapter.records[row].direction != null &&
        GridDataAdapter.records[row].direction !== '')
       return '<div style="text-align:center;">'+
              '<img style="margin-top: 14px;" height="20" '+
              'src="../images/' +
              GridDataAdapter.records[row].direction +
              '.png"/></div>';
     else
       return '<br>';
  }

  $("#titlegrid").jqxGrid(
  {
      width: cMainGridWidth,
      rowsheight : 150,
      autoheight: true,
      showemptyrow: false,
      theme: GTheme,
      columns: [
        { text: "&nbsp;&nbsp;<b>"+GSyncoveryTitle+"</b>"+GLicenseMsgBR+GLicenseMsg, width: cTitleGridCol1Width },
        { text: '', width: cTitleGridCol2Width }
      ]
  });

  var G_ShedIdleTimeAfterStartupCb = true;

  const LastUsedComboSource=["Any","1 Day","2 Days","3 Days","1 Week","2 Weeks","1 Month","3 Months","6 Months","1 Year","2 Years","3 Years"];

  $("#jqxgrid").jqxGrid(
  {
    width: cMainGridWidth,
    rowsheight : 50,
    source: GridDataAdapter,
    pageable: true,
    pagesize:15,
    pagermode: "default",
    altRows: true,
    autoheight: true,
    autorowheight: true,
    virtualmode: true,
    theme: GTheme,
    selectionmode: 'singlerow',
    showtoolbar: true,
    toolbarheight: GDefaultGridToolbarHeight,
    rendergridrows: function ()
    {
      return GridDataAdapter.records;
    },

    rendertoolbar: function (toolbar)
    {
      var container = $(
        '<table class="toolrow" id="toolbarTable"><tr><td>'+
        '<button style="margin-left: 10px;" id="addrowbutton" type="button" title="Add New Profile"></button>'+
        '<button style="margin-left: 10px;" id="updaterowbutton" type="button" title="Edit Profile"></button>'+
        '<button style="margin-left: 10px;" id="renamebutton" type="button" title="Rename Profile"></button>'+
        '<button style="margin-left: 10px;" id="deletebutton" type="button" title="Delete Profile"></button>'+
        '<button style="margin-left: 10px;" id="run_selected_profile_button" type="button" title="Run Profile Unattended"></button>'+
        '<button style="margin-left: 10px;" id="run_attended_button" type="button" title="Run Profile With Preview"></button>'+
        '<button style="margin-left: 10px;" id="show_status_button" type="button" title="Show Detailed Status"></button>'+
        '<button style="margin-left: 10px;" id="stop_selected_profile_button" type="button" title="Stop Profile"></button>'+
        '<button style="margin-left: 10px;" id="program_settings_button" type="button" title="Program Settings"></button>'+
        '<button style="margin-left: 10px;" id="account_manager_button" type="button" title="Account Manager"></button>'+
        '<button style="margin-left: 10px;" id="log_files_button" type="button" title="Log Files"></button>'+
        '<button style="margin-left: 10px;" id="start_scheduler_button" type="button" value="Stop" title="Start or Stop Scheduler"></button>'+
        '<button style="margin-left: 10px;" id="refresh_grid_button" type="button" title="Refresh"></button>'+
        '<button style="margin-left: 10px;" id="logout_button" type="button" title="Logout"></button>'+
        '<button style="margin-left: 10px;" id="help_button" type="button" title="Help"></button>'+
        '&nbsp;&nbsp;&nbsp;&nbsp;<label id="lbl_Filter" for="inpt_Filter">Filter:</label> <input type="text" aria-labelledby="lbl_Filter" id="inpt_Filter"/>'+
        '</td><td>&nbsp;&nbsp;&nbsp;&nbsp;Last Used Within:&nbsp;&nbsp;'+
        '</td><td><span style="display:inline-block;" id ="jqxLastUsedCombo"></span>'+
        '</td><td>&nbsp;&nbsp;</td><td><div id="jqxShowScheduledCB" style="margin-left: 10px; display:inline;">Show Scheduled Profiles Only</div></td>'+
        '</tr></table>');
                    
      toolbar.append(container);

      $("#addrowbutton").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/1.Add48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#addrowbutton").on('click', AddProfile);

      $("#updaterowbutton").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/2.Edit48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#updaterowbutton").on('click', EditSelectedProfile);

      $("#renamebutton").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/3.Rename48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#renamebutton").on('click', function ()
        { RenameProfile(false); }
        );

      $("#deletebutton").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/4.Delete48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#deletebutton").on('click', DeleteProfile);

      $("#run_selected_profile_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth, imgSrc:"images/5.Play48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#run_selected_profile_button").on('click',
        function ()
        {
           RunSelectedProfile(false);
        });

      $("#run_attended_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/5.PlayPreview48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#run_attended_button").on('click',
        function ()
        {
           RunSelectedProfile(true);
        });

      $("#show_status_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/eyeperfect48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#show_status_button").on('click',ShowDetailedStatus);

      $("#stop_selected_profile_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/7.Stop48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#stop_selected_profile_button").on('click', StopSelectedProfile);

      $("#program_settings_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/10.Settings48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#program_settings_button").on('click', OnProgramSettings);

      $("#account_manager_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/accmgr48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#account_manager_button").on('click', showAccountDialog);

      $("#log_files_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/11.LogFiles48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#log_files_button").on('click', LogFiles);

      $("#start_scheduler_button").jqxButton({height: GIconBtnHeight, width: GBtnWidth,imgSrc:"images/Scheduler48m.png",imgWidth:27,imgHeight:24,imgPosition:"left",textPosition: "left",textImageRelation: "imageBeforeText"});
      $("#start_scheduler_button").on('click', function ()
      {
        const label = $('#start_scheduler_button').text().trim();

        if (GisSyncoveryDebug) console.log("Scheduler button: "+label);
        if (label === 'Start' )
        {
           StartScheduler();
        }
        else if (label === 'Stop')
        {
           StopScheduler();
        }
      });

      $("#refresh_grid_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/refresh48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#refresh_grid_button").on('click', RefreshGrid);

      $("#logout_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/logout48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#logout_button").on('click', PerformLogout);

      $("#help_button").jqxButton({height: GIconBtnHeight, width: GIconBtnWidth,imgSrc:"images/help48.png",imgWidth:24,imgHeight:24,imgPosition:"center"});
      $("#help_button").on('click', ShowHelp);

      $("#inpt_Filter").jqxInput({width: 100,  height: 25});
      $("#inpt_Filter").on('change', RefreshGrid);

		    $("#jqxLastUsedCombo").jqxDropDownList({
		      source: LastUsedComboSource,
		      selectedIndex: 0,
		      width: 80,
		      dropDownWidth: 80,
		      dropDownHeight: 400,
		      height: 25});

      $("#jqxShowScheduledCB").jqxCheckBox({width: 50,  height: 25});
      $("#jqxShowScheduledCB").on('change', RefreshGrid);

      // add tab stops and make accessible
      [
        "addrowbutton",
        "updaterowbutton",
        "renamebutton",
        "deletebutton",
        "run_selected_profile_button",
        "run_attended_button",
        "show_status_button",
        "stop_selected_profile_button",
        "program_settings_button",
        "account_manager_button",
        "log_files_button",
        "start_scheduler_button",
        "refresh_grid_button",
        "logout_button",
        "help_button"
      ].forEach(id => {
        const $el = $("#" + id);
        // make focusable + give an accessible name
        if (!$el.attr("tabindex")) $el.attr("tabindex", "0");
        if (!$el.attr("aria-label")) {
          const label = $el.attr("title") || id.replace(/_/g, " ");
          $el.attr("aria-label", label);
        }
      });


      var refreshInterval = setInterval(CheckForEventFunc, GisSyncoveryDebug ? 1000 : 1000);
      CheckForEventFunc(); // show status immediately
    },

  columns: [
      { text: ' ', datafield: 'id', width: 12, cellsrenderer: imagerenderer },
//            { text: 'Group', datafield: 'Group', width: 225 },
      { text: 'Profile Name', datafield: 'HTMLName', width: 225 /*, cellsrenderer: namerenderer */ },
      { text: 'Left-Hand Path', datafield: 'LeftPath', width: 320 },
      { text: 'Dir.', datafield: 'direction', width: 40, cellsrenderer: directionrenderer, align: "center", cellsalign: "center" },
      { text: 'Right-Hand Path', datafield: 'RightPath', width: 320 },
      { text: 'Last Result or Progress', datafield: 'Progress', width: 410 },
      { text: 'Last Run', datafield: 'LastRun', width: 179 },
      { text: 'Next Run', datafield: 'NextRun', width: 179 }
     ]
//        groupable: true,
//        groups: ['Group']
 });

 $("#jqxLoader").jqxLoader({ width: 100, height: 60, imagePosition: 'top' });

 $('#jqxgrid').on('pagechanged', function (event)
    {
       GProfileListChanged = true;
    });


 $('#jqxgrid').on('rowdoubleclick', function (event)
 {
   var args = event.args;
   // row's bound index.
   var boundIndex = args.rowindex;
   // row's visible index.
   var visibleIndex = args.visibleindex;
   // right click.
   var rightclick = args.rightclick;
   // original event.
   var ev = args.originalEvent;
   if (!rightclick)
     setTimeout(EditSelectedProfile, 100);
 });

  $("#jqxgrid").on('mousedown', function (event) {
         var rightClick = isRightClick(event) || $.jqx.mobile.isTouchDevice();
         if (rightClick) {
             var scrollTop = $(window).scrollTop();
             var scrollLeft = $(window).scrollLeft();
             if (parseInt(event.clientY) > 100)
               contextMenu.jqxMenu('open', parseInt(event.clientX) + GDefaultTabletMouseDownInterval + scrollLeft, parseInt(event.clientY) + GDefaultTabletMouseDownInterval + scrollTop);
             return false;
         }
     });

 // disable the default browser's context menu.
 $("#jqxgrid").on('contextmenu', function (e) {
     return false;
 });


 function isRightClick(event) {
     var rightclick;
     if (!event) var event = window.event;
     if (event.which)
       rightclick = (event.which == 3);
     else if (event.button) rightclick = (event.button == 2);
     return rightclick;
 }

 function EditSelectedProfile()
 {
      showstatusmessage("Opening profile");
      var selectedRow = $('#jqxgrid').jqxGrid('getselectedrowindex');
      if (selectedRow == -1)
      {
         showstatusmessage("No profile selected");
         alert("No profile selected");
         return;
      }

       var SelectedRow = $('#jqxgrid').jqxGrid('getrowdata', selectedRow);
       if (!SelectedRow)
       {
          showstatusmessage("No row selected");
          alert("No row selected");
          return;
       }
       var SelectedProfile = SelectedRow.Name;

       $('#jqxLoader').jqxLoader('open');

       var sendparams = { };
       sendparams.ProfileName = SelectedProfile.trim();
       sendparams.token = GClientToken;
       var json = JSON.stringify(sendparams);
       ProfileSource.url = "single_profile.php?qry=" +encodeURIComponent(json);

       showstatusmessage("Loading profile");
       var ProfileDataAdapter = new $.jqx.dataAdapter(ProfileSource,
        { loadComplete: function ()
          {
            showstatusmessage("Loading profile complete");
            if (ProfileDataAdapter.xhr.responseText == '{"error":"session_timeout"}')
            {
                $('#jqxLoader').jqxLoader('close');
                window.location = '/index.html';
                showstatusmessage("Loading error: session timeout");
                alert("Loading error: session timeout");
                return;
            }
            else if (ProfileDataAdapter.xhr.responseText == '{"error":"session_busy"}')
            {
                $('#jqxLoader').jqxLoader('close');
                window.location = '/post_session_busy.php';
                showstatusmessage("Loading error: session busy");
                alert("Loading error: session busy");
                return;
            }
            else
            if (ProfileDataAdapter.xhr.responseText == '{"error":"profile_locked"}')
            {
                $('#jqxLoader').jqxLoader('close');
                showstatusmessage("Loading error: profile locked");
                alert("Cannot edit - profile is locked.");
                return;
            }
            else
            if (ProfileDataAdapter.xhr.responseText.substring(0,8) == '{"error"')
            {
               $('#jqxLoader').jqxLoader('close');
               showstatusmessage("Loading error: " + ProfileDataAdapter.xhr.responseText);
               alert(ProfileDataAdapter.xhr.responseText);
               return;
            }

            // get data records.
            var records = ProfileDataAdapter.records;
            var length = records.length;

            showstatusmessage("Processing profile");

            for (var i = 0; i < length; i++)
            {
               var record = records[i];
               if (SelectedProfile == record.Name)
               {
                  LoadRecordToRegistryList(record, GProfileEditorRegistryList, "");
                  //alert('LoadRecordToRegistryList done');

                  showstatusmessage("Initializing Profile Editor Form");
                  GFuncInitProfileEditorForm(SelectedProfile, "Edit");
                  showstatusmessage("Profile Editor Form Ready");
                  return;
               }
            }
            showstatusmessage("Closing loader pop-up");
            $('#jqxLoader').jqxLoader('close');
            showstatusmessage("Showing error");
            alert('Profile to edit not found');
          }
          ,
          loadError: function (jqXHR, status, error)
          {
            showstatusmessage("Loading error: "+error);
            $('#jqxLoader').jqxLoader('close');
            if (error == "")
               alert("Error. Connection with server might be lost.");
            else
               alert("Profile Loading Error: "+error);
           }
       });

       ProfileDataAdapter.dataBind();
 };
      
  function DoAddProfile()
 {
    LoadDefaultsToRegistryList(GProfileEditorRegistryList, true);
    LoadSSHDefaults();
    GFuncInitProfileEditorForm("", "Insert");
 }

 function AddProfile()
 {
    setTimeout(function(){ DoAddProfile(); }, 100);
    $('#jqxLoader').jqxLoader('open');
 };

       


 function EnableDisableProfile(enableit)
 {
    var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
    var rowscount = $("#jqxgrid").jqxGrid('getdatainformation').rowscount;
    if (selectedrowindex >= 0 && selectedrowindex < rowscount) {
                 
        var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;
        var sendparams = { };
        sendparams.ProfileName = SelectedProfile.trim();
        sendparams.EnableIt = enableit;
        sendparams.token = GClientToken;
        var json = JSON.stringify(sendparams);
        $.post("post_enabledisableprofile.php", json).done(function(data)
        {
          if ((data == 'OK' ) || (data == 'Disabled') || (data == 'Enabled'))
          {
           RefreshGrid();
          }
          else
             alert( "Profile could not be modified: " + data);
        });
            
    }
 };

 function PauseResumeProfile(resumeit)
 {
    var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
    var rowscount = $("#jqxgrid").jqxGrid('getdatainformation').rowscount;
    if (selectedrowindex >= 0 && selectedrowindex < rowscount)
    {
        var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;
        var sendparams = { };
        sendparams.ProfileName = SelectedProfile.trim();
        sendparams.ResumeIt = resumeit;
        sendparams.token = GClientToken;
        var json = JSON.stringify(sendparams);

        $.post("post_pauseresumeprofile.php", json).done(function(data)
        {
           if (data == 'OK' )
           {
              RefreshGrid();
           }
           else
              alert( "This was not possible: " + data);
        });
    }
 };


 function LockProfile(lockit)
 {
    var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
    var rowscount = $("#jqxgrid").jqxGrid('getdatainformation').rowscount;
    if (selectedrowindex >= 0 && selectedrowindex < rowscount)
    {
        var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;
        var sendparams = { };
        sendparams.ProfileName = SelectedProfile.trim();
        sendparams.LockIt = lockit;
        sendparams.token = GClientToken;
        var json = JSON.stringify(sendparams);

        $.post("post_lockprofile.php", json).done(function(data)
        {
           if (data == 'OK' )
           {
              // var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
              // var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;
              RefreshGrid();
           }
           else
              alert( "This was not possible: " + data);
        });
    }
 };



   
 function DiagnoseActivity()
 {

    var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
    var rowscount = $("#jqxgrid").jqxGrid('getdatainformation').rowscount;
    if (selectedrowindex >= 0 && selectedrowindex < rowscount) {
                 
        var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;
        var sendparams = { };
        sendparams.ProfileName = SelectedProfile.trim();
        sendparams.token = GClientToken;
        var json = JSON.stringify(sendparams);

        $.post("post_diagnose_activity.php", json).done(function(data)
               {
                alert("Please enable pop-ups, we will now try to open a new tab or window");
                window.open(data);
               }
           );
    }
 };

 function DumpMemoryUsage()
 {

        var sendparams = { };
        sendparams.token = GClientToken;
        var json = JSON.stringify(sendparams);

        $.post("dump_memory_usage.php", json).done(function(data)
               {
                alert(data);
               }
           );
          
 };

 function ShowDetailedStatus()
 {

    var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
    var rowscount = $("#jqxgrid").jqxGrid('getdatainformation').rowscount;
    if (selectedrowindex >= 0 && selectedrowindex < rowscount) {

        var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;

        window.open("status.php?token="+GClientToken+"&profile="+encodeURIComponent(SelectedProfile.trim()));
    }
 };
 function ExportProfile()
 {
    var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
    var rowscount = $("#jqxgrid").jqxGrid('getdatainformation').rowscount;
    if (selectedrowindex >= 0 && selectedrowindex < rowscount)
    {
        var SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;
        window.open("exportprofile.php?token="+GClientToken+"&profile="+encodeURIComponent(SelectedProfile.trim()));
    }
 };
 function ExportProfiles()
 {
    window.open("exportprofiles.php?token="+GClientToken);
 };
 function ShowHelp()
 {
    window.open("help/help.html");
 };

 function PerformLogout()
 {
    window.location.replace("logout.php?token="+GClientToken);
 }

 function LogFiles()
 {

    var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
    var rowscount = $("#jqxgrid").jqxGrid('getdatainformation').rowscount;
    {
        var SelectedProfile;
        if (selectedrowindex >= 0 && selectedrowindex < rowscount)
           SelectedProfile = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex).Name;

        var sendparams = { };
        if (SelectedProfile)
           sendparams.ProfileName = SelectedProfile.trim()
        else
           sendparams.ProfileName = '';
        sendparams.token = GClientToken;
        var json = JSON.stringify(sendparams);
       // $.post("post_log_files.php", json).done(function(data)
       // {
       //    if (data != '')
       //    {
              var selectedrowindex = $("#jqxgrid").jqxGrid('getselectedrowindex');
              var SelectedProfileItem = $('#jqxgrid').jqxGrid('getrowdata', selectedrowindex);
              var SelectedProfile;
              if (SelectedProfileItem)
                 SelectedProfile = SelectedProfileItem.Name;

              $("#LogFilesDlg_div").html(LogFilesDlgHTML);

                 $('#jqxLogFilesDlg').jqxWindow({ maxWidth: 900,  width:900, maxHeight:650, height:650, autoOpen: false, isModal: true,
                     theme: GTheme, animationType: 'slide', closeButtonAction: 'close' });


                  var GridSource =
                  {
                      datatype: "json",
                      id: 'id',
                      url: "logfiles.json",
                      root: "Rows",
                      datafields: [
                          { id: 'id', type:'number' },
                          { name: 'LogFileName', type: 'string' }]
                  };

                   var GridDataAdapter = new $.jqx.dataAdapter(GridSource,
                  {
                      downloadComplete: function (data, status, xhr) { },
                      loadComplete: function (data) { },
                      loadError: function (xhr, status, error) {
                                 
                      },
                      beforeSend: function (xhr) {
                        if (SelectedProfile)
                           xhr.setRequestHeader('ProfileName', SelectedProfile);
                        xhr.setRequestHeader('token', GClientToken);
                      }
                  });

                 $('#jqx_log_grid').jqxGrid({
                  width: 850,
                  height:550,
                  rowsheight : 50,
                  source: GridDataAdapter,
                  pageable: true,
                  pagesize:20,
                  autoheight: false,
                  //virtualmode: true,
                  columns: [

                    { text: ' ', datafield: 'id', width: 50 },
                    { text: 'Log File', datafield: 'LogFileName', width: 800 }                                  ]

                });


                      
                $('#LogFiles_Close_btn').jqxButton({});
                $('#LogFiles_Close_btn').off('click');
                $('#LogFiles_Close_btn').click(function () {

                    $('#jqxLogFilesDlg').jqxWindow('destroy');
                });
                                
                $('#jqxLogFilesDlg').on('close', function (event) {
          
                    $('#jqxLogFilesDlg').jqxWindow('destroy'); }
               );

                 $('#jqxLogFilesDlg').jqxWindow('open');
                 $('#jqxLogFilesDlg').jqxWindow('focus');
                    
              //alert("profile '" + SelectedProfile + " :"  + data);
          // }
                                  
        //});
    }

 };

 function TerminateProcess()
 {
    if (confirm('Web server process will be terminated. Are you sure ?'))
    {
        var sendparams = { };
        sendparams.token = GClientToken;
        var json = JSON.stringify(sendparams);
        $.post("terminate_process.php", json).done(function(data)
        {
           if (data != '')
           {
              alert("Termination of syncovery web server process info: "   + data);
           }
                                  
        });
    }
 };

 if (GisSyncoveryDebug) console.log("InitMainForm done");

} // function InitMainForm


